/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.overlay.DisplayHelper;

public class ArmorElement
extends Element {
    public static final ResourceLocation ARMOR = ResourceLocation.withDefaultNamespace((String)"hud/armor_full");
    public static final ResourceLocation HALF_ARMOR = ResourceLocation.withDefaultNamespace((String)"hud/armor_half");
    public static final ResourceLocation EMPTY_ARMOR = ResourceLocation.withDefaultNamespace((String)"hud/armor_empty");
    private final float armor;
    private String text;
    private int iconsPerLine = 1;
    private int lineCount = 1;
    private int iconCount = 1;

    public ArmorElement(float armor) {
        this.armor = armor;
        IPluginConfig config = IWailaConfig.get().plugin();
        if (armor > (float)config.getInt(JadeIds.MC_ENTITY_ARMOR_MAX_FOR_RENDER)) {
            if (!config.get(JadeIds.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
                armor = Mth.ceil((float)armor);
            }
            this.text = DisplayHelper.dfCommas.format(armor);
        } else {
            int maxHeartsPerLine = config.getInt(JadeIds.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            this.iconCount = Mth.ceil((float)(armor *= 0.5f));
            this.iconsPerLine = Math.min(maxHeartsPerLine, this.iconCount);
            this.lineCount = Mth.ceil((float)(armor / (float)maxHeartsPerLine));
        }
        if (this.showText()) {
            this.width = DisplayHelper.font().width(this.text) + 10;
            this.height = 9;
        } else {
            this.width = 8 * this.iconsPerLine + 1;
            this.height = 5 + 4 * this.lineCount;
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        IDisplayHelper helper = IDisplayHelper.get();
        int x = this.getX();
        int y = this.getY();
        int xOffset = (this.iconCount - 1) % this.iconsPerLine * 8;
        int yOffset = this.lineCount * 4 - 4;
        for (int i = this.iconCount; i > 0; --i) {
            helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, EMPTY_ARMOR, x + xOffset, y + yOffset, 9, 9);
            if (i <= Mth.floor((float)this.armor)) {
                helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, ARMOR, x + xOffset, y + yOffset, 9, 9);
            }
            if ((float)i > this.armor && (float)i < this.armor + 1.0f) {
                helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, HALF_ARMOR, x + xOffset, y + yOffset, 9, 9);
            }
            if ((xOffset -= 8) >= 0) continue;
            xOffset = this.iconsPerLine * 8 - 8;
            yOffset -= 4;
        }
        if (this.showText()) {
            helper.drawText(graphics, this.text, (float)(x + 10), (float)(y + 1), IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    public Component getNarration() {
        return Component.translatable((String)"narration.jade.armor", (Object[])new Object[]{Mth.ceil((float)this.armor)});
    }

    public boolean showText() {
        return this.text != null;
    }
}

